(
	-- Arch&Design Material

    struct AMGData
	(
		fn GetUUID mtl context = 
		(
			"15b1323b-7add-4998-8d52-acebedd81dea"
		)
		,
		fn GetMaps mtl context = 
		(
			local res = #()	

			if mtl.base_color_shader != undefined and mtl.base_color_connected do 
				append res #("base_color", mtl.base_color_shader)

			if mtl.diffuse_weight_shader != undefined and mtl.diffuse_weight_connected do 
				append res #("diffuse_weight",   mtl.diffuse_weight_shader, "resultFloat")

			if mtl.edge_color_shader != undefined and mtl.edge_color_connected do 
				append res #("pearl_color",      mtl.edge_color_shader)

			if mtl.edge_color_bias_shader != undefined and mtl.edge_color_bias_connected do 
				append res #("pearl_angle",      mtl.edge_color_bias_shader, "resultFloat")

			if mtl.lit_color_shader != undefined and mtl.lit_color_connected do 
				append res #("metal_color",      mtl.lit_color_shader)

			if mtl.spec_weight_shader != undefined and mtl.spec_weight_connected do 
				append res #("metal_weight",     mtl.spec_weight_shader, "resultFloat")

			if mtl.flake_color_shader != undefined and mtl.flake_color_connected do 
				append res #("flake_color",      mtl.flake_color_shader)

			if mtl.flake_density_shader != undefined and mtl.flake_density_connected do 
				append res #("flake_density",    mtl.flake_density_shader, "resultFloat") 

			if mtl.flake_scale_shader != undefined and mtl.flake_scale_connected do 
				append res #("flake_size",       mtl.flake_scale_shader, "resultFloat") 

			if mtl.reflection_color_shader != undefined and mtl.reflection_color_connected do 
				append res #("coat_color",       mtl.reflection_color_shader) 

			if mtl.reflection_edge_weight_shader != undefined and mtl.reflection_edge_weight_connected do 
				append res #("coat_high",        mtl.reflection_edge_weight_shader, "resultFloat") 

			if mtl.reflection_base_weight_shader != undefined and mtl.reflection_base_weight_connected do 
				append res #("coat_low",         mtl.reflection_base_weight_shader, "resultFloat") 

			if mtl.edge_factor_shader != undefined and mtl.edge_factor_connected do 
				append res #("coat_exponent",    mtl.edge_factor_shader, "resultFloat") 

			if mtl.dirt_color_shader != undefined and mtl.dirt_color_connected do 
				append res #("dirt_color",       mtl.dirt_color_shader) 

			if mtl.dirt_weight_shader != undefined and mtl.dirt_weight_connected do 
				append res #("dirt_mix",         mtl.dirt_weight_shader, "resultFloat") 

			res
		),

		fn GetParams mtl context =
		(
			local res = #()	

			append res #("base_color",       mtl.base_color)
			append res #("diffuse_weight",   mtl.diffuse_weight)
			append res #("pearl_color",      mtl.edge_color)
			append res #("pearl_mix",        1.0)
			append res #("pearl_angle",      mtl.edge_color_bias)

			append res #("metal_color",      mtl.lit_color)
			append res #("metal_weight",     mtl.spec_weight)
			append res #("metal_gloss",      mtl.lit_color_bias / 20.0) -- totally fudged

			append res #("flake_color",      mtl.flake_color)

			-- flake weight is completely non-physical in the mr shader and has to be fudged completely
			append res #("flake_weight",     mtl.flake_weight / 3.0)
			append res #("flake_gloss",      mtl.flake_exp / 100.0) -- totally fudged
			append res #("flake_perturb",    mtl.flake_strength / 10.0) 
			append res #("flake_density",    mtl.flake_density) 
			append res #("flake_size",       mtl.flake_scale) 

			append res #("coat_color",       mtl.reflection_color) 
			append res #("coat_high",        mtl.reflection_edge_weight) 
			append res #("coat_low",         mtl.reflection_base_weight) 
			append res #("coat_exponent",    mtl.edge_factor) 
			append res #("coat_gloss",       (1.0 - mtl.glossy_spread)) 

			append res #("dirt_color",       mtl.dirt_color) 
			append res #("dirt_mix",         mtl.dirt_weight) 

			res
		)
	)

	AMGData()	
)
